function xprime=pointmass_derivatives(t,x)

global mustar lambdastar wl c k wh a w m B R I
global usave tsave

v=x(1);
omega=x(2);
lambda0hat=x(3);
xi=x(4);
eta=x(5);
lambda=(v-R*omega)/v;
J=2*mustar*lambdastar*lambda/(lambdastar^2+lambda^2);
lambda0=lambda0hat+a*sin(w*t);

N=m*9.8;
u=-c*I*v*(lambda-lambda0)-B*omega-I*omega*(-N*J/m)/v-m*R*(-N*J/m)+0*rand(1);
xprime(1)=-N*J/m;
xprime(2)=(-B*omega+N*R*J-u)/I;
xprime(3)=k*xi;
xprime(4)=wl*(sin(w*t)*(J-eta)-xi);
xprime(5)=wh*(J-eta);

xprime=xprime.';
tsave = [tsave;t];
usave = [usave;u];
 